#include <bits/stdc++.h>
using namespace std;

#define int long long
const int N=2e5+4,V=1025;
int a[N],b[N],o[N],dp[2][V],n;
bool tr[N];

struct trienode{
    int val;
    trienode *deca[2];
};

trienode *make(){
    trienode *cur=new trienode;
    cur->val=0;
    cur->deca[0]=NULL;
    cur->deca[1]=NULL;
    return cur;
}

void insert(trienode*root,int x){
    trienode *cur=root;
    for(int i=31;i>=0;--i){
        bool b=x&(1<<i);
        if(cur->deca[b]==NULL)
            cur->deca[b]=make();
        cur=cur->deca[b];
    }
    cur->val=x;
}

int qry(trienode*root,int x){
    trienode *cur=root;
    for(int i=31;i>=0;--i){
        bool b=x&(1<<i);
        if(cur->deca[!b]!=NULL)
            cur=cur->deca[!b];
        else if(cur->deca[b]!=NULL)
            cur=cur->deca[b];
    }
    return x^(cur->val);
}

void resettrie(trienode*root){
    if(root==NULL)
        return;
    resettrie(root->deca[0]);
    resettrie(root->deca[1]);
    delete root;
}

int get(int l,int r){
    if(l>r)return 0;
    trienode*root=make();
    resettrie(root);
    root=make();
    insert(root,(l?a[l-1]:0ll));
    int res=0;
    for(int i=l;i<=r;++i){
        res=max(res,qry(root,a[i]));
        insert(root,a[i]);
    }
    return res;
}

int brute(){
    int ans=0;
    for(int l=0;l<n;++l){
        int c1=0,c2=b[l];
        for(int r=l;r>=0;--r){
            c1^=a[r];
            c2&=b[r];
            ans=max(ans,c1*c2);
        }
    }
    return ans;
}

int calc(){
    int len=0,res=0;
    for(int i=0;i<n;++i){
        if(!tr[i]){
            res=max(res,get(i-len,i-1));
            len=0;
        }else
            ++len;
    }
    return max(res,get(n-len,n-1));
}

int sfb(){
    for(int i=0;i<n;++i)
        tr[i]=(b[i]&1);
    int ans=calc();
    for(int i=0;i<n;++i)
        tr[i]=(b[i]&2);
    ans=max(ans,calc()*2);
    for(int i=0;i<n;++i)
        tr[i]=(b[i]==3);
    ans=max(ans,calc()*3);
    return ans;
}

int sfa(){
    for(int i=0;i<V;++i)
        dp[0][i]=dp[1][i]=0;
    dp[0][a[0]]=a[0];
    int ret=a[0]*b[0];
    for(int i=1;i<n;++i) {
        fill(dp[1],dp[1]+n,0);
        for(int x=0;x<=V;++x){
            if(dp[0][x]>0){
                int nw1=x^a[i],nw2=dp[0][x]&b[i];
                dp[1][nw1]=max(dp[1][nw1],nw2);
                ret=max(ret,nw1*dp[1][nw1]);
            }
        }
        dp[1][a[i]]=max(dp[1][b[i]],b[i]);
        ret=max(ret,a[i]*b[i]);
        swap(dp[0],dp[1]);
    }
    return ret;
}

signed main(){
    ios::sync_with_stdio(0);
    cin.tie(0);
    
    cin>>n;
    for(int i=0;i<n;++i){
        cin>>a[i];
        o[i]=a[i];
    }
    for(int i=0;i<n;++i)
        cin>>b[i];

    if(n<=2000){
        cout<<brute();
        return 0;
    }

    bool ai=1;
    for(int i=0;i<n;++i)
        ai&=(a[i]==1);

    if(ai){
        cout<<*max_element(b,b+n);
        return 0;
    }

    for(int i=1;i<n;++i)
        a[i]^=a[i-1];

    bool bm=1;
    for(int i=0;i<n;++i)
        bm&=(b[i]<=3);

    if(bm){
        cout<<sfb();
        return 0;
    }

    for(int i=0;i<n;++i)
        a[i]=o[i];

    ai=1;
    for(int i=0;i<n;++i)
        ai&=(a[i]<=500);

    if(ai){
        cout<<sfa();
        return 0;
    }

    for(int i=1;i<n;++i)
        a[i]^=a[i-1];

    fill(tr,tr+n+1,1);
    stack<pair<int,vector<bool>>>st;
    int ans=0,prosli=-1;

    vector<bool>poc(n,1);
    st.push({0,poc});

    int msb=0;
    for(int i=0;i<n;++i){
        int cmsb=-1,tmp=b[i];
        while(tmp){
            ++cmsb;
            tmp>>=1;
        }
        msb=max(msb,cmsb);
    }

    for(int bit=msb;bit>=0;--bit){
        vector<bool>cur(n);
        for(int i=0;i<n;++i)
            cur[i]=((b[i]&(1ll<<bit))!=0);
        for(int i=0;i<n;++i)
            tr[i]=st.top().second[i]&cur[i];
        int sad=calc()*(st.top().first+(1ll<<bit));
        if(st.size()==1){
            ans=max(ans,sad);
            for(int i=0;i<n;++i)
                cur[i]=tr[i];
            st.push({st.top().first+(1ll<<bit),cur});
            continue;
        }
        stack<pair<int,vector<bool>>>tp;
        int mx=sad,koji=0,ovaj=1,aa=0;
        while(st.size()>1){
            tp.push(st.top());
            st.pop();
            for(int i=0;i<n;++i)
                tr[i]=st.top().second[i]&cur[i];
            int sadbez=calc()*(st.top().first+(1ll<<bit));
            if(sadbez>mx){
                aa=1;
                mx=sadbez;
                koji=ovaj;
            }
            ++ovaj;
        }
        ans=max(ans,mx);
        if(!aa){
            while(!tp.empty())
                st.push(tp.top()),tp.pop();
        }
        for(int i=0;i<ovaj-koji&&tp.size()&&aa;++i){
            st.push(tp.top());
            tp.pop();
        }
        for(int i=0;i<n;++i)
            cur[i]=st.top().second[i]&cur[i];
        st.push({st.top().first+(1ll<<bit),cur});
    }

    cout<<ans<<'\n';
}